// PPgConnection3.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "emule.h"
#include "PPgDisplay2.h"
#include "emuledlg.h"
#include "Preferences.h"
#include "Scheduler.h"
#include "OtherFunctions.h"
#include "preferencesdlg.h"

//==> VQB: fullChunk [shadow2004]
#ifdef CLIENTANALYZER
#include "UploadQueue.h"
#endif
//<== VQB: fullChunk [shadow2004]


IMPLEMENT_DYNAMIC(CPPgConnection3, CPropertyPage)

BEGIN_MESSAGE_MAP(CPPgConnection3, CPropertyPage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_CON3, OnTcnSelchangeTabConnection3)
	ON_EN_KILLFOCUS(IDC_CON3_LMAX, OnSettingsChange)
	ON_EN_KILLFOCUS(IDC_CON3_MAXPER5, OnSettingsChange)
	ON_EN_KILLFOCUS(IDC_CON3_MAXHALF, OnSettingsChange)
	ON_EN_KILLFOCUS(IDC_CON3_FU, OnSettingsChange)
        ON_BN_CLICKED(IDC_CON3_FASTREJECT, OnBnClickedFastreject)
	ON_WM_HSCROLL()
END_MESSAGE_MAP()

CPPgConnection3::CPPgConnection3()
	: CPropertyPage(CPPgConnection3::IDD)
{
	m_imageList.DeleteImageList();
	m_imageList.Create(16, 16, theApp.m_iDfltImageListColorFlags | ILC_MASK, 14+1, 0);
	m_imageList.Add(CTempIconLoader(_T("CONNECTION")));
	m_imageList.Add(CTempIconLoader(_T("HARDLIMIT")));
	m_imageList.Add(CTempIconLoader(_T("CONNECTION")));
}

CPPgConnection3::~CPPgConnection3()
{
}

void CPPgConnection3::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_CON3, m_tabCtr);
	DDX_Control(pDX, IDC_CON3_LMAX, m_ctlConLimitMax);
	DDX_Control(pDX, IDC_CON3_MAXPER5, m_ctlConLimitMax5);
	DDX_Control(pDX, IDC_CON3_MAXHALF, m_ctlConLimitHalf);
	DDX_Control(pDX, IDC_CON3_FU, m_ctlFuChunks);
}


BOOL CPPgConnection3::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
//>>> shadow2004::Tabbed Prefs [TPT] reworked
	InitTab(true);
	m_tabCtr.SetCurSel(2);
//<<< shadow2004::Tabbed Prefs [TPT] reworked
	InitWindowStyles(this);

	if (thePrefs.m_bConditionalTCPAccept)
		CheckDlgButton(IDC_CON3_FASTREJECT,1);

	LoadSettings();
	Localize();

	return TRUE; 
}

void CPPgConnection3::Localize(void)
{
	if(m_hWnd)
	{
		GetDlgItem(IDC_CON3_LBOX)->SetWindowText(GetResString(IDS_PW_CONLIMITS));
		GetDlgItem(IDC_CON3_LMAX_LBL1)->SetWindowText(GetResString(IDS_PW_MAXC));
		GetDlgItem(IDC_CON3_MAXPER5_LBL1)->SetWindowText(GetResString(IDS_MAXCON5SECLABEL));
		GetDlgItem(IDC_CON3_MAXHALF_LBL1)->SetWindowText(GetResString(IDS_MAXHALFOPENCONS));
		GetDlgItem(IDC_CON3_FASTREJECT)->SetWindowText(GetResString(IDS_CONDTCPACCEPT));
		GetDlgItem(IDC_CON3_FUBOX)->SetWindowText(GetResString(IDS_CON3_FUBOX));
		GetDlgItem(IDC_CON3_FU_LBL1)->SetWindowText(GetResString(IDS_FUCHUNKS));
	}
}

void CPPgConnection3::LoadSettings(void)
{
	CString strBuffer;

	m_ctlConLimitMax.SetRange(25, 2500);
	m_ctlConLimitMax.SetPos(thePrefs.maxconnections);
	m_ctlConLimitMax.SetTicFreq(25);

	strBuffer.Format(_T("%d"), m_ctlConLimitMax.GetPos());
	GetDlgItem(IDC_CON3_LMAX_LBL2)->SetWindowText(strBuffer);

	m_ctlConLimitMax5.SetRange(1, 500);
	m_ctlConLimitMax5.SetPos(thePrefs.GetMaxConperFive());
	m_ctlConLimitMax5.SetTicFreq(25);

	strBuffer.Format(_T("%d"), m_ctlConLimitMax5.GetPos());
	GetDlgItem(IDC_CON3_MAXPER5_LBL2)->SetWindowText(strBuffer);

	m_ctlConLimitHalf.SetRange(1, 500);
	m_ctlConLimitHalf.SetPos(thePrefs.GetMaxHalfConnections());
	m_ctlConLimitHalf.SetTicFreq(25);

	strBuffer.Format(_T("%d"), m_ctlConLimitHalf.GetPos());
	GetDlgItem(IDC_CON3_MAXHALF_LBL2)->SetWindowText(strBuffer);

	CheckDlgButton(IDC_CON3_FASTREJECT, (UINT)thePrefs.GetConditionalTCPAccept());

	m_ctlFuChunks.SetRange(1, 255);
	m_ctlFuChunks.SetPos(thePrefs.GetFUChunks());
	m_ctlFuChunks.SetTicFreq(10);

	strBuffer.Format(_T("%d"), m_ctlFuChunks.GetPos());
	GetDlgItem(IDC_CON3_FU_LBL2)->SetWindowText(strBuffer);
}

BOOL CPPgConnection3::OnApply()
{
	thePrefs.maxconnections = m_ctlConLimitMax.GetPos();

	if (thePrefs.maxconnections > (unsigned)::GetMaxWindowsTCPConnections())
	{
		CString strMessage;
		strMessage.Format(GetResString(IDS_PW_WARNING), GetResString(IDS_PW_MAXC), ::GetMaxWindowsTCPConnections());
		int iResult = AfxMessageBox(strMessage, MB_ICONWARNING | MB_YESNO);
		if (iResult != IDYES)
		{
			//TODO: set focus to max connection?
			thePrefs.maxconnections = ::GetMaxWindowsTCPConnections();
		}
	}

	thePrefs.SetMaxConsPerFive(m_ctlConLimitMax5.GetPos());
	theApp.scheduler->original_cons5s = thePrefs.GetMaxConperFive();
	
	thePrefs.SetMaxHalfConnections(m_ctlConLimitHalf.GetPos());

	if(IsDlgButtonChecked(IDC_CON3_FASTREJECT))
		thePrefs.m_bConditionalTCPAccept = true;
	else
		thePrefs.m_bConditionalTCPAccept = false;

	if(thePrefs.GetFUChunks() != (uint8)m_ctlFuChunks.GetPos())
	{
		thePrefs.SetFUChunks((uint8)m_ctlFuChunks.GetPos());
		theApp.uploadqueue->UpdateRemainingUp();
	}
	theApp.scheduler->SaveOriginals();

	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgConnection3::InitTab(bool firstinit, int Page)
{
	if (firstinit) {
		m_tabCtr.DeleteAllItems();
		m_tabCtr.SetImageList(&m_imageList);
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection1, GetResString(IDS_CON1_NAME), 0, (LPARAM)Connection1); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection2, GetResString(IDS_CON2_NAME), 1, (LPARAM)Connection2); 
		m_tabCtr.InsertItem(TCIF_TEXT | TCIF_IMAGE | TCIF_PARAM, Connection3, GetResString(IDS_CON3_NAME), 2, (LPARAM)Connection3); 
	}

	m_tabCtr.SetCurSel(Page);
}
void CPPgConnection3::OnTcnSelchangeTabConnection3(NMHDR* /*pNMHDR*/, LRESULT *pResult)
{
	int cur_sel = m_tabCtr.GetCurSel();
	theApp.emuledlg->preferenceswnd->SwitchTab(cur_sel);
	*pResult = 0;
}

void CPPgConnection3::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CString strBuffer;
	if (pScrollBar == GetDlgItem(IDC_CON3_LMAX))
	{
		strBuffer.Format(_T("%d"), m_ctlConLimitMax.GetPos());
		GetDlgItem(IDC_CON3_LMAX_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
	if (pScrollBar == GetDlgItem(IDC_CON3_MAXPER5))
	{
		strBuffer.Format(_T("%d"), m_ctlConLimitMax5.GetPos());
		GetDlgItem(IDC_CON3_MAXPER5_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
	if (pScrollBar == GetDlgItem(IDC_CON3_MAXHALF))
	{
		strBuffer.Format(_T("%d"), m_ctlConLimitHalf.GetPos());
		GetDlgItem(IDC_CON3_MAXHALF_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}
	if (pScrollBar == GetDlgItem(IDC_CON3_FU))
	{
		strBuffer.Format(_T("%d"), m_ctlFuChunks.GetPos());
		GetDlgItem(IDC_CON3_FU_LBL2)->SetWindowText(strBuffer);

		SetModified(TRUE);
	}

	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CPPgConnection3::OnBnClickedFastreject()
{
	SetModified();
}